<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Flex
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Twilio\Rest\FlexApi\V2;

use Twilio\Exceptions\TwilioException;
use Twilio\Version;
use Twilio\InstanceContext;


class FlexUserContext extends InstanceContext
    {
    /**
     * Initialize the FlexUserContext
     *
     * @param Version $version Version that contains the resource
     * @param string $instanceSid The unique ID created by Twilio to identify a Flex instance.
     * @param string $flexUserSid The unique id for the flex user to be retrieved.
     */
    public function __construct(
        Version $version,
        $instanceSid,
        $flexUserSid
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        'instanceSid' =>
            $instanceSid,
        'flexUserSid' =>
            $flexUserSid,
        ];

        $this->uri = '/Instances/' . \rawurlencode($instanceSid)
        .'/Users/' . \rawurlencode($flexUserSid)
        .'';
    }

    /**
     * Fetch the FlexUserInstance
     *
     * @return FlexUserInstance Fetched FlexUserInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): FlexUserInstance
    {

        $payload = $this->version->fetch('GET', $this->uri, [], []);

        return new FlexUserInstance(
            $this->version,
            $payload,
            $this->solution['instanceSid'],
            $this->solution['flexUserSid']
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.FlexApi.V2.FlexUserContext ' . \implode(' ', $context) . ']';
    }
}
